

/******************************************************************************************************
 **                                                                                                  **
 **                     EX3.1 : Counter Number 0-9 Display DSP1(for ET-DISPLAY 8x32RED)              **
 **                     Use : Dot-Matrix(8x8=4 digit) #LDM1088A ,Drive #Max7219                      **
 **                                                                                                  ** 
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         :   AVR Easy Mega 328 (ET-CPU DISPLAY8x32)                                   **
 **                     :   X-TAL : 16 MHz                                                           ** 
 **                                                                                                  **
 **  Editor/Compiler    :   Arduino 1.8.1                                                            **
 **                                                                                                  **                   
 **  Port Interface    :   Arduino Mega328 PIN                        Device Interface               **
 **                         ----------------------                     --------------                **                      
 **  Dot-Matrix         :   Pin D10-OUT (PB2)                           CS/Load-Max7219              **
 **                         Pin D11-OUT (PB3)                           DIN-Max7219                  **
 **                         Pin D12-OUT (PB4)                           CLK-Max7219K                 **
 **                                                                                                  **                                                                                                 **
 **  Create By          :   Mr.Sittiphol Yooyod (WWW.ETT.CO.TH)                                      **
 **  Last Update        :   7/December/2018                                                          ** 
 **                                                                                                  ** 
 ******************************************************************************************************/

// MAX7219 commands:
#define CMD_NOOP   0
#define CMD_DIGIT0 1
#define CMD_DIGIT1 2
#define CMD_DIGIT2 3
#define CMD_DIGIT3 4
#define CMD_DIGIT4 5
#define CMD_DIGIT5 6
#define CMD_DIGIT6 7
#define CMD_DIGIT7 8
#define CMD_DECODEMODE  9
#define CMD_INTENSITY   10
#define CMD_SCANLIMIT   11
#define CMD_SHUTDOWN    12
#define CMD_DISPLAYTEST 15

#define NUM_MAX      4    //Number Max7219 4 Ship

/************ Define Pin **************/

//--Dot Matrix Pin for Max7219----
#define CS_PIN       10
#define DIN_PIN      11
#define CLK_PIN      12

                               //Colum      0       1         2      3
static byte ScrBuf[8][4] = {   //Position  DSP0   -DSP1    -DSP2   -DSP3       
                    {0,0,0,0},    //data   D8-D0   D8-D0   D8-D0   D8-D0  ---Row0(A0) 
                    {0,0,0,0},    //data   D8-D0   D8-D0   D8-D0   D8-D0
                    {0,0,0,0},             
                    {0,0,0,0},
                    {0,0,0,0},
                    {0,0,0,0},
                    {0,0,0,0},
                    {0,0,0,0}    //data   D8-D0   D8-D0   D8-D0   D8-D0   ---Row7(A7)
                  };           //Ex Font   'A'




/****************************************************************
 *                              Data Font                       *
 **************************************************************** 
 * //-First Byte of font[0] is NumByte / Charecter
 * -First Byte of font[0] is Type Font 1= Cuttom font,2=Full font
 * -First byte of Charecter is bit wide of Charecter     
 * -Font Read Hor Colum [ D7...D0] 
 * -Plot First Byte  from Up to Down   
 * -Font Close Left  
 *   
 * -----------------------------------------  
 *      8  4  2  1  8  4  2  1 ----->Weight
 *     D7 D6 D5 D4 D3 D2 D1 D0 ----->Data 1Byte
 *   -----------------------------
 * 0|   0  #  #  #  0  0  0  0   = 0x70    ----->    ,Ex Font0 size 5x7           
 * 1|   #  0  0  0  #  0  0  0   = 0x88
 * 2|   #  0  0  0  #  0  0  0   = 0x88
 * 3|   #  0  0  0  #  0  0  0   = 0x88
 * 4|   #  0  0  0  #  0  0  0   = 0x88
 * 5|   #  0  0  0  #  0  0  0   = 0x88
 * 6|   0  #  #  #  0  0  0  0   = 0x70  
 * 7|   0  0  0  0  0  0  0  0   = 0x00
 *  
 *  '0' = {5,0x70,0x88,0x88,0x88,0x88,0x88,0x70,0x00} 
*/  

//---------------------Font Number----------------------------------
const unsigned char Bfont6x8[] PROGMEM = {         //Font Bold Plot 
0x78,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0x78,// 0
0x30,0xF0,0x30,0x30,0x30,0x30,0x30,0xFC,// 1
0x78,0xcc,0x0c,0x18,0x30,0x60,0xc0,0xfc,// 2
0x78,0xcc,0x0c,0x38,0x0c,0x0c,0xcc,0x78,// 3
0x18,0x38,0x78,0xd8,0xd8,0xfc,0x18,0x18,// 4
0xfc,0xc0,0xc0,0xf8,0x0c,0x0c,0xcc,0x78,// 5
0x78,0xcc,0xc0,0xf8,0xcc,0xcc,0xcc,0x78,// 6
0xfc,0x0c,0x0c,0x18,0x30,0x30,0x30,0x30,// 7
0x78,0xcc,0xcc,0x78,0xcc,0xcc,0xcc,0x78,// 8
0x78,0xcc,0xcc,0xcc,0x7c,0x0c,0xcc,0x78 // 9
};


//----------------------Font Clear buffer --------------

const unsigned char BClr[] PROGMEM = {         //Font Clear buffer
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};




/*************************************************************************
 **    Function : Sent Command+Data 2Byte(16Bit) to Max7219 4-Ship      **
 *************************************************************************/            
  
void SendCmdAll(byte cmd, byte data)
{
  int dp ;
  
  digitalWrite(CS_PIN, LOW);
  
  for(dp=0 ; dp< NUM_MAX ; dp++)                 //Loop 4 round for Max7219 4 Ship
   {
     shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, cmd) ; //Shift command 8 bit byte High(D15-D8)
     shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, data); //Shift Data 8 bit byte Low(D7-D0) 
   }

  digitalWrite(CS_PIN, LOW);
  digitalWrite(CS_PIN, HIGH);
}



/****************************************************************
 **       Function : Refress Screen All (4 Display=8x32 Dot)   **
 ****************************************************************/       

void RefreshAll() 
{
  char rw,dp  ;
  
  //------------- Refresh Screen All --------------------------
  
  for (rw = 0; rw < 8 ; rw++)  //Loop Scan 8 Row  Start A0-A7 
   {
    digitalWrite(CS_PIN, LOW);
    
    for(dp = 3 ; dp >= 0 ; dp--) //Loop NUM_MAX=4 (0-3)
     {
      shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, CMD_DIGIT0 + rw)   ; //Shift cmm 8bit byte High (Row Address Start Row 0(Ver.))
      shiftOut(DIN_PIN, CLK_PIN, MSBFIRST, ScrBuf[rw][dp])    ; //Shift data 8bit byte Low (Sent Serial data Start Buffer[row0][Colum3]
     }
    digitalWrite(CS_PIN, LOW);
    digitalWrite(CS_PIN, HIGH);                                 //Latch Data to Display
   }

  
}




/**************************************************************************************************************
 **                           Function : Plot data to Screen Buffer                                          **      
 **************************************************************************************************************           
 **  Paramiter :                                                                                             **
 **              dsp = Position dsp buffer 0-3 for keep data                                                 **                                                      
 **       *name_font = Name Table font                                                                       **      
 **                                                                                                          **
 **************************************************************************************************************/
 
void PlotDot(char dsp, const unsigned char *name_font)
{
  byte dt ;
  char col,row ;
       
   for(row=0;row<8;row++)                   //Loop Number Byte Data of 1 Charecter row 0-7
    {
      dt = pgm_read_byte(name_font+row) ;   //Read Data 1 Byte of font from 8 Byte
      ScrBuf[row][dsp] = dt             ;   //update Data 1 byte of Charecter to buffer colume Dsp 4 colum 
        
    } //for row
} //End Show Number



/********************************************************
 **            Function:Initial Max7219                **
 ********************************************************/          
void InitMAX7219()
{
  pinMode(DIN_PIN, OUTPUT)         ;   //D11
  pinMode(CLK_PIN, OUTPUT)         ;   //D13
  pinMode(CS_PIN, OUTPUT)          ;   //D10
  digitalWrite(CS_PIN, HIGH)       ;
  digitalWrite(CLK_PIN, LOW)       ;  //****************
    
  SendCmdAll(CMD_DISPLAYTEST, 0)   ;  //Set Display Normal Mode
  SendCmdAll(CMD_SCANLIMIT, 7)     ;  //Set Scan 8 digit is 100 HZ 
  SendCmdAll(CMD_DECODEMODE, 0)    ;
  SendCmdAll(CMD_INTENSITY, 15)    ; //Bright Max=15 ,Min=0
  SendCmdAll(CMD_SHUTDOWN, 0)      ;

  RefreshAll()                     ; 
  SendCmdAll(CMD_SHUTDOWN,1)       ;

}



// ########################## Setup ####################################

void setup() 
{
  InitMAX7219();
}
 
// ########################## Main Program #############################

void loop()
{ 
  int num=0 ;
  
  while(1)
   {
     PlotDot(0,Bfont6x8+(8*num)) ; //Position Start data Buffont array[0]=Number0
     RefreshAll()                ;
     delay(1000)                 ;
     num++                       ;

     if(num >9)                 
        num=0                     ;     //Clear count to 0
   }
}  // end void







